require("dotenv").config();
const express = require("express");
const cors = require("cors");
const fs = require("fs");
const path = require("path");
const https = require("https");
const enquiryRouter = require("./api/router");


const app = express();

app.use(express.json());

const options = {
  cert: fs.readFileSync(path.resolve(__dirname, 'ftvgym.crt')),
  key: fs.readFileSync(path.resolve(__dirname, 'ftvgym.key')),
};



let corsOptions = {};

if (process.env.NODE_ENV === "production") {
  corsOptions = {
    origin: "https://ftvgym.in",
    // origin: "http://localhost:3032/",
    methods: "GET,POST",
    credentials: true,
  };
} else {
  corsOptions = {
    origin: "*",
  };
}
// app.use(cors(corsOptions));
app.use(cors("https://ftvrealestate.in"));

app.use("/api/enquiry", enquiryRouter);

// const PORT = 3609;
const PORT = 3034;

const server = https.createServer(options, app);

server.listen(PORT, () => {
  console.log(`Server is listening at port ${PORT}`);
});
// app.listen(PORT, () => {
//   console.log(`server is listning at  post ${PORT}`);
// });

app.get("/", (req, res) => {
  res.send("Welcome to the node project");
});
